<?php

include_once('../../../init.php');

use WHMCS\Database\Capsule;

/**
 *  Sms Service
 */
class SmsService
{
    private $db;

    function __construct()
    {
        $this->db = DatabaseProcess::getInstance();
    }

    public function getHooksName()
    {
        if ($handle = opendir(dirname(__FILE__) . '/hooks')) {
            while (false !== ($entry = readdir($handle))) {
                if (substr($entry, strlen($entry) - 4, strlen($entry)) == ".php") {
                    $names[] = substr($entry, 0, strlen($entry) - 4);
                }
            }
            closedir($handle);
        }
        return $names;
    }

    public function initializeHooks($hooks = null)
    {
        $hook_name = "";
        if ($hooks == null) {
            $hooks = $this->getHooks();
        }
        $i = 0;
        try {
            $this->db->beginTransaction();
            foreach ($hooks as $hook) {

                $sql_count = "SELECT COUNT(*) FROM `interaktif_sms_templates`
                 WHERE `name` = '" . $hook['function'] . "' AND `type` = '" . $hook['type'] . "' LIMIT 1";
                $stmt_count = $this->db->runSelectQuery($sql_count);

                if ($stmt_count->fetchColumn() == 0) {
                    if ($hook['type']) {

                        $sql = "INSERT INTO `interaktif_sms_templates`(`id`, `name`,`name_tr`, `smsfieldname`, `type`, `template`, `variables`, `extra`, `description`, `title`, `active`)
                        VALUES (NULL,'" . $hook['function'] . "','" . $hook['hook_tr'] . "','','" . $hook['type'] . "','" . $hook['defaultmessage'] . "','" . $hook['variables'] . "',
                        '" . (isset($hook['extra']) ? $hook['extra'] : "") . "','" . json_encode(@$hook['description'], JSON_UNESCAPED_UNICODE) . "','" . $hook['title'] . "',0)";
                        $result = $this->db->runSqlQuery($sql);

                        if (!$result) {
                            throw new Exception("Hooks are not initialized");
                        }
                        $i++;
                    }
                }
            }

            $this->db->commit();
            return $i;
        } catch (Exception $e) {
            $this->db->rollBack();
            return 0;
        }
    }

    public function getHooks()
    {
        $file = array();
        if ($handle = opendir(dirname(__FILE__) . '/hooks')) {
            while (false !== ($entry = readdir($handle))) {
                if (substr($entry, strlen($entry) - 4, strlen($entry)) == ".php") {
                    array_push($file, include_once('hooks/' . $entry));
                }
            }
            closedir($handle);
        }
        return $file;
    }

    public function setFields()
    {
        $query = "INSERT INTO `interaktif_sms_fields` (`id`, `hook_id`, `field`, `field_tr`) VALUES
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'orderid', 'Sipariş Numarası'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'companyname', 'Firma Adı'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'email', 'E-mail'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'address1', 'Adres 1'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'address2', 'Adres 2'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'city', 'Şehir'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'country', 'Ülke'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AcceptOrderr' LIMIT 1), 'phonenumber', 'Telefon Numarası'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AdminLogin' LIMIT 1), 'username', 'Kullanıcı Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleChangePackage' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleChangePackage' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleChangePackage' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleChangePassword' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleChangePassword' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleChangePassword' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleCreate_Hosting' LIMIT 1), 'username', 'Kullanıcı Adı'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleCreate_Hosting' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleCreate_Hosting' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleCreate_Hosting' LIMIT 1), 'domain', 'Alan Adı'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleCreate_Hosting' LIMIT 1), 'password', 'Şifre'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleSuspend' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleSuspend' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleSuspend' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleUnsuspend' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleUnsuspend' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterModuleUnsuspend' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistration' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistration' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistration' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistrationFailed' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistrationFailed' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistrationFailed' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistrationFailed_admin' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRegistration_admin' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRenewal' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRenewal' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRenewal' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRenewalFailed_admin' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='AfterRegistrarRenewal_admin' LIMIT 1), 'domain', 'Alan Adı'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAdd' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAdd' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAdd' LIMIT 1), 'password', 'Şifre'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAdd' LIMIT 1), 'email', 'E-mail'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAreaRegister' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAreaRegister'), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAreaRegister' LIMIT 1), 'code', 'Doğrulama Kodu'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientLoginOtpAuth' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientLoginOtpAuth' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientLoginOtpAuth' LIMIT 1), 'code', 'Doğrulama Kodu'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAdd_admin' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAdd_admin' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientAdd_admin' LIMIT 1), 'email', 'E-mail'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientChangePassword' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientChangePassword' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientChangePassword' LIMIT 1), 'password', 'Şifre'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientLogin_admin' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientLogin_admin' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='ClientLogin_admin' LIMIT 1), 'email', 'E-mail'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='DomainRenewalNotice' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='DomainRenewalNotice' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='DomainRenewalNotice' LIMIT 1), 'domain', 'Alan Adı'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='DomainRenewalNotice' LIMIT 1), 'expirydate', 'Bitiş Tarihi'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='DomainRenewalNotice' LIMIT 1), 'x', 'Kalan Gün'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoiceCreated' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoiceCreated' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoiceCreated' LIMIT 1), 'duedate', 'Son Ödeme Tarihi'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoiceCreated' LIMIT 1), 'total', 'Tutar'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoiceCreated' LIMIT 1), 'invoiceid', 'Fatura Numarası'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaid' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaid' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaid' LIMIT 1), 'duedate', 'Son Ödeme Tarihi'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaid' LIMIT 1), 'invoiceid', 'Fatura Numarası'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_Firstoverdue' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_Firstoverdue' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_Firstoverdue' LIMIT 1), 'duedate', 'Son Ödeme Tarihi'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_Reminder' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_Reminder' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_Reminder' LIMIT 1), 'duedate', 'Son Ödeme Tarihi'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_secondoverdue' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_secondoverdue' LIMIT 1), 'duedate', 'Son Ödeme Tarihi'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_secondoverdue' LIMIT 1), 'firstname', 'İsim'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_thirdoverdue' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_thirdoverdue' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='InvoicePaymentReminder_thirdoverdue' LIMIT 1), 'duedate', 'Son Ödeme Tarihi'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketAdminReply' LIMIT 1), 'ticketid', 'Ticket Numarası'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketAdminReply' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketAdminReply' LIMIT 1), 'lastname', 'Soyisim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketAdminReply' LIMIT 1), 'subject', 'Konu'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketAdminReply' LIMIT 1), 'message', 'Mesaj'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketClose' LIMIT 1), 'ticketid', 'Ticket Numarası'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketClose' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketClose' LIMIT 1), 'lastname', 'Soyisim'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketOpen_admin' LIMIT 1), 'ticketid', 'Ticket Numarası'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketOpen_admin' LIMIT 1), 'subject', 'Konu'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketOpen_admin' LIMIT 1), 'message', 'Mesaj'),

(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketUserReply_admin' LIMIT 1), 'ticketid', 'Ticket Numarası'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketUserReply_admin' LIMIT 1), 'subject', 'Konu'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketUserReply_admin' LIMIT 1), 'message', 'Mesaj'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketOpen' LIMIT 1), 'ticketid', 'Ticket Numarası'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketOpen' LIMIT 1), 'firstname', 'İsim'),
(NULL, (SELECT id FROM interaktif_sms_templates WHERE name='TicketOpen' LIMIT 1), 'lastname', 'Soyisim');";

        $this->db->beginTransaction();

        $result = $this->db->runSqlQuery($query);

        if ($result) {
            $this->db->commit();
            return true;
        } else {
            $this->db->rollBack();
            return false;
        }
    }

    function isJson($string)
    {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE) ? true : false;
    }

    public function getTitleAsArray($usercode = '', $password = '')
    {
        include_once('sender/Request.php');

        if (trim($usercode) == '' or trim($password) == '') {

            $stmt = $this->getSettings();
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if (!empty($row['msgheaders']) and trim($row['msgheaders']) != '') {
                if ($this->isJson($row['msgheaders'])) {
                    return json_decode($row['msgheaders'], true);
                }
            }
            $usercode = $row['usercode'];
            $password = $row['password'];
        }


        $titles = Request::HTTPGET($usercode, $password);

        
            $sql = "update interaktif_sms_settings set msgheaders='$titles'";
            $this->getConnection()->runSelectQuery($sql);
        
       
      return array($titles);
    }

    public function getSettings()
    {
        return $this->db->runSelectQuery("SELECT * FROM `interaktif_sms_settings`");
    }

    public function countClients($query)
    {
        $result = $this->getConnection()->runSelectQuery($query);
        return $result->fetch(PDO::FETCH_ASSOC)['total'];
    }

    public function getConnection()
    {
        return $this->db;
    }

    public function getClientAllGroupNames()
    {
        $query = "SELECT groupname FROM tblclientgroups";
        return $this->getConnection()->runSelectQuery($query);
    }

    public function updateSettings($u, $p, $f, $d, $autoauthkey = '', $blockedsmsfieldname = '', $loginredirectpage = '', $loginpage = '', $smslanguage = '')
    {
        try {
            $conn = DatabaseProcess::getInstance();
            $sql = "UPDATE interaktif_sms_settings SET usercode=? , password=?, smsfieldname=?, defaultmsgheader=?, autoauthkey = ?, blockedsmsfieldname = ?,loginredirectpage =?,loginpage=?, smslanguage = ?";
            $stmt = $conn->runSelectQuery($sql, array($u, $p, $f, $d, $autoauthkey, $blockedsmsfieldname, $loginredirectpage, $loginpage, $smslanguage));
            if ($stmt != false and $stmt->rowCount() > 0) {
                $sql = "UPDATE interaktif_sms_templates SET title = ?";
                $stmt = $conn->runSelectQuery($sql, array($d));
            }
            if ($stmt != false) {
                return array('status' => true, 'description' => 'Güncelleme Başarılı.');
            } else {
                return array('status' => false, 'description' => 'Güncelleme Başarısız!','error'=>$stmt->errorInfo());
            }
        } catch (Exception $e) {
            return array('status' => false, 'description' => $e->getMessage() . ' Güncelleme Başarısız!');
        }
    }

    public function getTemplateDetailsTR($template = null)
    {
        $query = "SELECT * FROM interaktif_sms_templates WHERE name_tr ='" . $template . "';";
        $result = $this->db->runSelectQuery($query);
        return $result;
    }

    public function getTemplateDetails($template = null)
    {
        $query = "SELECT * FROM `interaktif_sms_templates` WHERE `name` ='" . $template . "'";
        $result = $this->getConnection()->runSelectQuery($query);
        return $result;
    }

    public function getFields($templateId)
    {
        $sql = "SELECT `field`, `field_tr` FROM `interaktif_sms_fields` WHERE `hook_id`='" . $templateId . "';";

        return $this->db->runSelectQuery($sql);
    }

    public function getFieldsWithName($templateName)
    {
        $sql = "SELECT `field`, `field_tr` FROM `interaktif_sms_fields` WHERE `hook_id`=
                (SELECT id FROM interaktif_sms_templates WHERE name = '" . $templateName . "')";
        return $this->db->runSelectQuery($sql);
    }

    public function getAllTemplate()
    {
        $query = "SELECT `name`,`name_tr`,`type` FROM interaktif_sms_templates ORDER BY name_tr ASC";
        return $this->db->runSelectQuery($query);
    }

    public function getAllTemplates($type = "client")
    {
        $query = "SELECT `id`, `name`, `name_tr`, `type`, `admingsm`, `smsfieldname`, `template`, `title`, `variables`, `active`, `extra`, `description` FROM interaktif_sms_templates WHERE type ='" . $type . "' ORDER BY id ASC";
        if ($type === "admin") {
            $query = "SELECT `id`, `name`, `name_tr`, `type`, `admingsm`, `smsfieldname`, `template`, `title`, `variables`, `active`, `extra`, `description` FROM interaktif_sms_templates WHERE type ='" . $type . "' ORDER BY id ASC";
        }
        return $this->db->runSelectQuery($query);
    }

    public function XMLPOST($numbers, $message, $title = null)
    {
       
        $flag = false;

        include_once('sender/SMS.php');
        include_once('sender/Request.php');

        $SMSArray = [];
        $replaceFrom = "";
        $replaceTo = "";

        $settings = $this->getSettings();
        $row = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$row['usercode'] || !$row['password']) {
            return false;
        }
        $usercode = $row['usercode'];
        $password = $row['password'];

        if (is_null($title))
            $title = $row['defaultmsgheader'];

        $stmt = $this->getClientColumnNames();
        $columnNames = $stmt->fetchAll();

        for ($i = 0; $i < count($numbers); $i++) {
            $newMessage = $message;
            $arr = explode("_", $numbers[$i]);
            $client = $this->getClientDetailsBy($arr[0]);
            $row = $client->fetch(PDO::FETCH_ASSOC);

            if ($arr[1]{0} === "+") {
                $arr[1] = substr($arr[1], 3);
                $arr[1] = str_replace(".", "0", $arr[1]);
                $arr[1] = str_replace(" ", "", $arr[1]);
            }
          
            if (ctype_digit($arr[1])) {


                foreach ($columnNames as $column) {

                    $columnName = $column['COLUMN_NAME'];

                    if (strpos($newMessage, "{" . $columnName . "}") === false) {

                    } else {
                        $newMessage = str_replace("{" . $columnName . "}", $row[$columnName], $newMessage);
                    }
                }

                array_push($SMSArray, new SMS($newMessage, $arr[1]));
                $flag = true;
                
                
            }
        }

        if ($flag == true) {
            $request = new Request($title, $SMSArray, $usercode, $password);
            $request->prepareXMLRequest();
            return $request->XMLPOST();
        } else {
            return false;
        }
    }

    public function XMLPOSTOTP($number, $message, $title)
    {

    }

    public function getClientColumnNames()
    {
        $sql = "select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS
                where TABLE_NAME = 'tblclients';";

        return $this->db->runSelectQuery($sql);
    }

    public function getClientDetailsBy($clientId)
    {
        $userSql = "SELECT * FROM `tblclients` as `a` WHERE `a`.`id`  = '" . $clientId . "'
        LIMIT 1";
        return $this->db->runSelectQuery($userSql);
    }

    public function getClientDetailsWithSmsFieldName($smsfieldname, $clientId)
    {
        $sql = "SELECT c.firstname, c.lastname, c.companyname, c.email, c.address1, c.address2, c.city,
c.state, c.postcode, c.country, c.status, v.value as phonenumber
FROM tblclients as c, tblcustomfieldsvalues as v WHERE c.id='" . $clientId . "' AND c.id=v.relid AND v.fieldid=
(SELECT id from tblcustomfields where fieldname='" . $smsfieldname . "' AND type = 'client' AND fieldtype = 'text' LIMIT 1) LIMIT 1;";

        return $this->db->runSelectQuery($sql);
    }

    public function isUserBlockedToSms($userid)
    {
        $settings = $this->getSettings();
        $settings_row = $settings->fetch(PDO::FETCH_ASSOC);

        if (trim($settings_row['blockedsmsfieldname']) == '') {
            return "0";
        }

        $sql = "select case when v.value='on' then '1' else '0' end as blocked
                from tblclients as c
                inner join tblcustomfieldsvalues as v on v.relid=c.id
                where c.id=:usr and v.fieldid=(SELECT id from tblcustomfields where fieldname=:field AND type = 'client' LIMIT 1)";

        $stmt = $this->db->runSelectQuery($sql, array(':usr' => $userid, ':field' => $settings_row['blockedsmsfieldname']));
        $row = $stmt->fetch();

        return $row['blocked'];
    }

    public function updateTemplate($hookId, $title, $message, $admingsm, $extra, $smsfieldname)
    {
        if (empty($hookId))
            return false;
        $sql = "UPDATE `interaktif_sms_templates` SET `smsfieldname` = '" . $smsfieldname . "' ,`extra` = '" . $extra . "' , `admingsm` = '" . $admingsm . "'  ,`title` = '" . $title . "', `template` = '" . $message . "'
         WHERE `id` = '" . $hookId . "'";
        return $this->db->runSqlQuery($sql);
    }

    public function changeTemplateStatus($templateId, $status)
    {
        $sql = "UPDATE interaktif_sms_templates SET active = " . $status . " WHERE id = '" . $templateId . "';";
        return $this->getConnection()->runSqlQuery($sql);
    }

    public function preparePaginationLinks($count, $limit, $page, $function_name = "getClients")
    {
        $output = '';

//        $output.=  $count." ".$limit." ".$page;

        $pages = ceil($count / $limit);

        if ($pages > 1) {

            if ($page == 1)
                $output = $output . '<span class="link first disabled">&#8810;</span><span class="link disabled">&#60;</span>';
            else
                $output = $output . '<a class="link first" onclick="' . $function_name . '(1)" >&#8810;</a><a class="link" onclick="' . $function_name . '(' . ($page - 1) . ')">&#60;</a>';

            if (($page - 3) > 0) {
                if ($page == 1)
                    $output = $output . '<span id=1 class="link current">1</span>';
                else
                    $output = $output . '<a class="link" onclick="' . $function_name . '(1)" >1</a>';
            }
            if (($page - 3) > 1) {
                $output = $output . '<span class="dot">...</span>';
            }

            for ($i = ($page - 2); $i <= ($page + 2); $i++) {
                if ($i < 1) continue;
                if ($i > $pages) break;
                if ($page == $i)
                    $output = $output . '<span id=' . $i . ' class="link current">' . $i . '</span>';
                else
                    $output = $output . '<a class="link" onclick="' . $function_name . '(' . $i . ')" >' . $i . '</a>';
            }

            if (($pages - ($page + 2)) > 1) {
                $output = $output . '<span class="dot">...</span>';
            }
            if (($pages - ($page + 2)) > 0) {
                if ($page == $pages)
                    $output = $output . '<span id=' . ($pages) . ' class="link current">' . ($pages) . '</span>';
                else
                    $output = $output . '<a class="link" onclick="' . $function_name . '(' . $pages . ')" >' . ($pages) . '</a>';
            }

            if ($page < $pages)
                $output = $output . '<a  class="link" onclick="' . $function_name . '(' . ($page + 1) . ')" >></a><a  class="link" onclick="' . $function_name . '(' . $pages . ')" >&#8811;</a>';
            else
                $output = $output . '<span class="link disabled">></span><span class="link disabled">&#8811;</span>';

        }
        return $output;

    }

    public function getClients($limit = 10, $start = 0)
    {
        return $this->getConnection()->runSelectQuery("SELECT * FROM tblclients LIMIT " . $start . ", " . $limit);
    }

    public function getSelectAndCountQuery($inputs, $limit = 10, $start = 0)
    {
        $names = null;
        $email = null;
        $phonenumber = null;
        $status = null;
        $group = null;
        $settings = $this->getSettings();
        $row = $settings->fetch(PDO::FETCH_ASSOC);

        if (isset($inputs)) {
            if (!empty($inputs['inputName']))
                $names = $inputs['inputName'];
            if (!empty($inputs['inputEmail']))
                $email = $inputs['inputEmail'];
            if (!empty($inputs['inputPhone']))
                $phonenumber = $inputs['inputPhone'];
            if (!empty($inputs['inputGroup']))
                $group = $inputs['inputGroup'];
            if (!empty($inputs['inputStatus']))
                $status = $inputs['inputStatus'];
            if (!empty($inputs['inputLimit']))
                $limit = $inputs['inputLimit'];
            if (!empty($inputs['page']))
                $start = $limit * ($inputs['page'] - 1);

            if (!empty($row['smsfieldname']) && $inputs['inputPhoneType'] === $row['smsfieldname']) {
                $countQuery = "SELECT COUNT(c . id) as total FROM tblclients as c, tblcustomfieldsvalues as v WHERE c . id = v . relid ";
                $selectQuery = "SELECT c . id, c . firstname, c . lastname, c . email, c . country, c . city, c . companyname, c . status, v . value as phone
            FROM tblclients as c, tblcustomfieldsvalues as v WHERE c . id = v . relid ";
                $query = "";

                if ($names !== null) {
                    $query .= " AND (c . firstname LIKE '%" . $names . "%' OR c . lastname LIKE '%" . $names . "%' OR c . companyname LIKE '%" . $names . "%') ";
                }
                if ($email !== null) {
                    $query .= " AND c . email LIKE '%" . $email . "%' ";
                }
                if ($phonenumber !== null) {
                    $query .= " AND v . value LIKE '%" . $phonenumber . "%' ";
                }
                if ($status !== null) {
                    $query .= " AND c . status = '" . $status . "' ";
                }
                if ($group !== null) {
                    $query .= " AND c . groupid = (SELECT `id` FROM `tblclientgroups` WHERE groupname = '" . $group . "')";
                }

                $query .= " AND v . fieldid = (SELECT id from tblcustomfields
            where fieldname = '" . $row['smsfieldname'] . "' AND type = 'client' AND fieldtype = 'text' LIMIT 1) ";
                $countQuery .= $query;
                $selectQueryWithoutLimit = $selectQuery . $query;
                $query .= " LIMIT " . $start . ", " . $limit;
                $selectQuery .= $query;
            } else {
                $countQuery = "SELECT COUNT(*) as total FROM `tblclients`";
                $selectQuery = "SELECT `id`, `firstname`, `lastname`, `companyname`, `email`,`status`,`phonenumber` as phone FROM `tblclients` ";
                $query = "";
                $i = 0;

                if ($names !== null) {
                    $query .= " WHERE(firstname LIKE '%" . $names . "%' OR lastname LIKE '%" . $names . "%' OR companyname LIKE '%" . $names . "%') ";
                    $i = 1;
                }
                if ($email !== null && $i == 1) {
                    $query .= " AND email LIKE '%" . $email . "%' ";
                }
                if ($email !== null && $i == 0) {
                    $query .= " WHERE email LIKE '%" . $email . "%' ";
                    $i = 1;
                }
                if ($phonenumber !== null && $i == 1) {
                    $query .= " AND phonenumber LIKE '%" . $phonenumber . "%' ";
                }
                if ($phonenumber !== null && $i == 0) {
                    $query .= " WHERE phonenumber LIKE '%" . $phonenumber . "%' ";
                    $i = 1;
                }
                if ($status !== null && $i == 1) {
                    $query .= " AND status = '" . $status . "' ";
                }
                if ($status !== null && $i == 0) {
                    $query .= " WHERE status = '" . $status . "' ";
                    $i = 1;
                }
                if ($group !== null && $i == 1) {
                    $query .= " AND groupid = (SELECT `id` FROM `tblclientgroups` WHERE groupname = '" . $group . "')";
                }
                if ($group !== null && $i == 0) {
                    $query .= " WHERE groupid = (SELECT `id` FROM `tblclientgroups` WHERE groupname = '" . $group . "')";
                    $i = 0;
                }

                $countQuery .= $query;
                $selectQueryWithoutLimit = $selectQuery . $query;
                $query .= " LIMIT " . $start . ", " . $limit;
                $selectQuery .= $query;
            }


            return array("selectQuery" => $selectQuery, "countQuery" => $countQuery, "selectQueryWithoutLimit" => $selectQueryWithoutLimit);

        } else {
            return null;
        }


    }

    public function getUserInfoByUserId($userid = null, $fieldname = null)
    {
        if (is_numeric($userid)) {
            if (!is_null($fieldname)) {
                $sql = "SELECT c . id,c . firstname,c . lastname,c . email,c . country,c . city,c . companyname,c . status,v . value as phone
                FROM tblclients as c,tblcustomfieldsvalues as v WHERE c . id = v . relid AND v . fieldid = (SELECT id from tblcustomfields
                where fieldname =? AND type = 'client' AND fieldtype = 'text' LIMIT 1)
                and c . id =?";
                $stmt = $this->db->runSelectQuery($sql, array($fieldname, $userid));
                $row = $stmt->fetch();
                return $row;
            } else {
                $sql = " select c . id, c . firstname,c . lastname,c . email,c . country,c . city,c . companyname,c . status,c . phonenumber as phone from tblclients as c where id = ?";
                $stmt = $this->db->runSelectQuery($sql, array($userid));
                $row = $stmt->fetch();
                return $row;
            }
        }

        return false;
    }

    public function getOtpListQueries($otp_inputs, $limit = 10, $start = 0)
    {
        $page = $otp_inputs['page'];
        $inputPhone = $otp_inputs['inputPhone'];
        $inputUser = $otp_inputs['inputUser'];
        $inputStatus = $otp_inputs['inputStatus'];

        $where_array = array();
        $array_execute = array();

        if (isset($otp_inputs) and !empty($otp_inputs)) {

            if (isset($inputUser) and $inputUser != '') {
                $where_array[] = " userid =:usr";
                $array_execute[':usr'] = $inputUser;
            }
            if (isset($inputPhone) and $inputPhone != '') {
                $where_array[] = " phonenumber like :phone";
                $array_execute[':phone'] = " % " . $inputPhone . " % ";
            }
            if (isset($inputStatus) and $inputStatus != '') {
                $where_array[] = " durum =:durum";
                $array_execute[':durum'] = $inputStatus;
            }

        } else {
            return null;
        }

        if (!empty($where_array))
            $where_array = " where " . implode(' and ', $where_array);
        else
            $where_array = '';

        if (!empty($otp_inputs['page']))
            $start = $limit * ($otp_inputs['page'] - 1);

        $sql = "select * from interaktif_sms_otp " . $where_array . ' order by start_otp_date desc';
        $sql_limitless = $sql;
        $sql = $sql . ' LIMIT ' . $start . ', ' . $limit;
        $sql_count = "select count(id) as toplam from interaktif_sms_otp " . $where_array;

        return array("selectQuery" => $sql, "countQuery" => $sql_count, "selectQueryWithoutLimit" => $sql_limitless, 'array_execute' => $array_execute);

    }
}

class DatabaseProcess
{
    private static $connection = null;

    function __construct()
    {
        try {
            $this->connection = Capsule::connection()->getPdo();
        } catch (PDOException $e) {
            die("PDO CREATING EXCEPTION::: " . $e->getMessage());
        }
    }

    public static function getInstance()
    {
        if (self::$connection == null)
            self::$connection = new DatabaseProcess();

        return self::$connection;
    }

    function runSelectQuery($sql, $parameter = null)
    {
        $conn = $this->connection;
        $stmt = $conn->prepare($sql);
        if (is_null($parameter))
            $result = $stmt->execute();
        else
            $result = $stmt->execute($parameter);

        return $result ? $stmt : $result;
    }

    function runSqlQuery($sql, $parameter = null)
    {
        $conn = $this->connection;
        $stmt = $conn->prepare($sql);
        if (is_null($parameter))
            $result = $stmt->execute();
        else
            $result = $stmt->execute($parameter);
        return $result;
    }

    function beginTransaction()
    {
        $this->connection->beginTransaction();
    }

    function commit()
    {
        $this->connection->commit();
    }

    function rollBack()
    {
        $this->connection->rollBack();
    }

}

?>
