<?php

if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

try {
    require_once("sender/Request.php");
    require_once('sender/SMS.php');
    require_once('SmsService.php');

    $hooks = getHooks();
    foreach ($hooks as $hook) {
        add_hook($hook['hook'], 1, $hook['function'], "");
    }

    add_hook('ClientAreaHeadOutput', 1, function ($vars) {
        return '<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css" />
			<script src="//cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
			<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/4.4.0/bootbox.min.js"></script>';
    });

    add_hook('ClientLogout', 1, function ($vars) {
        unset($_SESSION['is_smsinteraktif_login_otp_sent']);
        unset($_SESSION['is_smsinteraktif_register_otp_sent']);
    });

    add_hook('ClientAreaHeaderOutput', 1, function ($vars) {

        $service = new SmsService();
        $settings = $service->getSettings();
        $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$settingsRow['usercode'] || !$settingsRow['password']) {
            return null;
        }
        $template = $service->getTemplateDetails('ClientAreaRegister');
        if ($template == false) {
            return null;
        }
        $templateRow = $template->fetch(PDO::FETCH_ASSOC);
        if ($templateRow['active'] == 0) {
            return null;
        }

        if (isset($vars['client'])) {

            $userid = $vars['client']['attributes']['id'];

            $sql = "SELECT `id`, `verification_code`, `reference_code`, `userid`, `phonenumber`, `start_otp_date`, `durum`,`islogin` FROM `interaktif_sms_otp` WHERE userid=" . $userid . " LIMIT 1";

            $stmt = $service->getConnection()->runSelectQuery($sql);
            if ($stmt != false) {
                $row = $stmt->fetch();
                $otp_id = $row['id'];
                $reference_code = $row['reference_code'];
                $durum = $row['durum'];
                $gonderilme_zamani = $row['start_otp_date'];
                $phonenumber = $row['phonenumber'];
                $islogin = $row['islogin'];
            }

            if ($durum === 0) {
                $html = '<form method="post" action="" onSubmit="" role="form" name="otpVerification" id="formOtpVerification">
							<input type="hidden" name="smsinteraktif_otp_action" id="smsinteraktif_otp_action" value="validateOtp">
							<input type="hidden" name="smsinteraktif_otp_id" id="smsinteraktif_otp_id" value="' . $otp_id . '">
							<input type="hidden" name="smsinteraktif_reference_code" id="smsinteraktif_reference_code" value="' . $reference_code . '">
							<div id="otp_modal" class="modal fade" role="dialog">
							  <div class="modal-dialog">
								<div class="modal-content">
								  <div class="modal-header">
                                      <div class="row">
                                        <div class="col-md-6 col-sm-6">
                                           <h4 class="modal-title">Telefon Doğrulama</h4>
                                        </div>
                                        <div class="col-md-6 col-sm-6">
                                              <label>Kalan Süre</label>
                                              <label id="otp_timer"></label>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                          </div>
                                      </div>
                                      
								  </div>
								  <div class="modal-body">
								    
									<div class="form-group">
                                        <div class="row">
                                            <div class="col-md-6 col-sm-6">
                                                <label for="otp">Doğrulama Kodu:</label>
                                            </div>
                                            <div class="col-md-6 col-sm-6">
                                                <input type="text" name="smsinteraktif_otp_code" class="form-control" id="smsinteraktif_otp_code">
                                            </div>
                                        </div>
									</div>
									 <div class="row">
                                          <div class="col-md-12 col-sm-12">
                                            <label>' . $phonenumber . ' </label> numaralı telefonunuza gelen doğrulama kodunuz giriniz.
                                          </div>      
                                      </div>
								  </div>
								  <div class="modal-footer">
								    <div class="row">
								        <div class="col-md-6" align="left">
                                            <button type="button" class="btn btn-primary" onclick="return resendOtp(this)" id="resend-otp" >Tekrar Gönder</button>
                                        </div>
                                        <div class="col-md-6">
                                            <button type="button" class="btn btn-success" onclick="return checkOtpForm(this);">Doğrula</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Kapat</button>
                                        </div>                                        
									</div>
								  </div>
								</div>
							  </div>
							</div>
						</form>';
            }

            return $html;

        }

    });

    add_hook('ClientAreaFooterOutput', 1, function ($vars) {

        $html = '';

        $service = new SmsService();
        $settings = $service->getSettings();
        $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$settingsRow['usercode'] || !$settingsRow['password']) {
            return null;
        }
        $template = $service->getTemplateDetails('ClientAreaRegister');
        if ($template == false) {
            return null;
        }
        $templateRow = $template->fetch(PDO::FETCH_ASSOC);
        if ($templateRow['active'] == 0) {
            return null;
        }
        if (isset($vars['client'])) {

            $userid = $vars['client']['attributes']['id'];

            $sql = "SELECT `id`, `verification_code`, `reference_code`, `userid`, `phonenumber`, `start_otp_date` 
                  ,TIMESTAMPDIFF(SECOND,now(),end_otp_date) as remaining_time, `durum`
                  ,(case when now()<end_otp_date then '0'
                  else '1' end) as timesup
                  FROM `interaktif_sms_otp` WHERE userid=" . $userid . " LIMIT 1";

            $stmt = $service->getConnection()->runSelectQuery($sql);
            if ($stmt != false) {
                $row = $stmt->fetch();
                $otp_id = $row['id'];
                $reference_code = $row['reference_code'];
                $durum = $row['durum'];
                $gonderilme_zamani = $row['start_otp_date'];
                $phonenumber = $row['phonenumber'];
                $remaining_time = $row['remaining_time'];
                $timesup = $row['timesup'];
            }

            if ($durum === 0) {
                $html .= '<script type="text/javascript">

					  document.addEventListener("DOMContentLoaded", function() {
					      
					      smsinteraktifOtpTimer(' . $remaining_time . ',' . $timesup . ');
						  $(\'#otp_modal\').modal(\'show\');
					  });
					  
                        function smsinteraktifOtpTimer(remaining_time,timesup) {
        
                            var x = setInterval(function () {
                    
                                remaining_time--;
                                seconds = Math.floor(remaining_time % 60);
                                minutes = Math.floor(remaining_time / 60);
                    
                                if (!isNaN(remaining_time)) {
                                    document.getElementById("otp_timer").innerHTML = " " + minutes + ":" + seconds;
                                } else {
                                    remaining_time = -1;
                                }
                    
                                if(timesup == 1){
                                    remaining_time = -1;
                                }
                                if (remaining_time < 0) {
                                    clearInterval(x);
                                    document.getElementById("otp_timer").innerHTML = "00:00";
                                }
                            }, 1000);
                        }
					  
                      function checkOtpForm() {
                      
                          var smsinteraktif_otp_code = document.getElementById("smsinteraktif_otp_code").value.trim();
                          var smsinteraktif_otp_id = document.getElementById("smsinteraktif_otp_id").value.trim();
                          var smsinteraktif_reference_code = document.getElementById("smsinteraktif_reference_code").value.trim();
                          
                          if(smsinteraktif_otp_code == \'\') {
                              swal({
                                  title: "UYARI",
                                  text: "' . $phonenumber . ' numaralı telefonunuza gelen doğrulama kodunuz giriniz.",
                                  type: "warning",
                                  confirmButtonText : "Tamam",
                                });
                          } else {
                          
                              var data ={smsinteraktif_otp_code:smsinteraktif_otp_code,smsinteraktif_otp_id:smsinteraktif_otp_id,smsinteraktif_reference_code:smsinteraktif_reference_code,action:"validateOtp"}  ;
                          
                              $.ajax({
                                  url: \'modules/addons/smsinteraktif/ajax.php\',
                                  type: \'POST\',
                                  data:data,
                                  success: function (data) {
                                      data=JSON.parse(data);
                                      
                                      if (data["status"] == 1) {
                                          swal({
                                                  title: "Başarılı!",
                                                  text: data["message"],
                                                  type: "success",
                                                  confirmButtonText : "Tamam",

                                              }, function() {
                                                    $(\'#otp_modal\').modal(\'hide\');
//                                                  window.location = "clientarea.php";
                                              });
                                          
                                      } else {
                                           swal({
                                                  title: "Başarısız!",
                                                  text: data["message"],
                                                  type: "warning",
                                                  confirmButtonText : "Tamam",
                                              });
                                      }
                                  },
                                  error: function (data) {
                                      console.log(\'Error:\', data);
                                  }
                              });
                              
                          }
                          
                          return false;
                      }
                  
                      function resendOtp(){
    
                        var smsinteraktif_otp_id = document.getElementById("smsinteraktif_otp_id").value.trim();
                        var smsinteraktif_reference_code = document.getElementById("smsinteraktif_reference_code").value.trim();
                        var data = {action:"resendOtp",smsinteraktif_otp_id:smsinteraktif_otp_id,smsinteraktif_reference_code:smsinteraktif_reference_code};
                        
                        $.ajax({
                          url: \'modules/addons/smsinteraktif/ajax.php\',
                          type: \'POST\',
                          data:data,
                          success: function (data) {
                              
                              data=JSON.parse(data);
                              
                              if (data["status"] == 1) {
                                  swal({
                                      title: "Başarılı!",
                                      text: data["message"],
                                      type: "success",
                                      confirmButtonText : "Tamam",
                                      
                                  }, function() {
//                                          window.location = "clientarea.php";
                                  });
                              
                                  document.getElementById("smsinteraktif_reference_code").value=data["reference_code"];
                                  smsinteraktifOtpTimer(data["remaining_time"],0);

                              } else {
                                   swal({
                                      title: "Başarısız!",
                                      text: data["message"],
                                      type: "warning",
                                      confirmButtonText : "Tamam",
                                      
                                  }, function() {
//                                          window.location = "clientarea.php";
                                  });
                              }
                          },
                          error: function (data) {
                              console.log(\'Error:\', data);
                          }
                      });
                      }
                  </script>';
            }


        }

        return $html;

    });

    ///////////////////////***************************************************///////////////////////

    add_hook('AdminAreaClientSummaryPage', 1, function ($vars) {
        $service = new SmsService();
        $row = $service->getSettings()->fetch();
        $smsfieldname = $row['smsfieldname'];
        $defaultmsgheader = $row['defaultmsgheader'];

        $script = '<script> 

  function sendSmssmsinteraktif(){
        var message = $("#smsmessage").val();
        var smsgonderuserid = $("#smsgonderuserid").val();
        var fieldname = $("#inputPhoneType").val();
        if(message.trim() == ""){
            alert("Bir Mesaj Giriniz");
            return false;
        }
         
        $.ajax({
            type: "POST",
            url:  "../modules/addons/smsinteraktif/ajax.php",
            data: {smsgonderuserid:smsgonderuserid,message:message,fieldname:fieldname},
            error: function(data){
                console.log(\'Error:\', data);
            },
            success: function(data) {           
                data = data.split(\' \');
                if(data[0]=="00"){
                    alert("Mesajınız Başarıyla Gönderildi.");
                }else{
                    alert("Mesaj Gönderimi Başarışız.");
                }
                }
            });
        }
    </script>
';

        $html = '';
//        $html .= '<div class="row client-summary-panels">';
//        $html .= '<div class="col-lg-3 col-sm-6">';
        $html .= '<div class="clientssummarybox">';
        $html .= '<div class="title">Sms Gönder</div>';
        $html .= '<div align="center">';

        $html .= '<input type="hidden" name="smsgonderuserid" id="smsgonderuserid" value="' . $vars['userid'] . '">';
        $html .= '<textarea class="form-control bottom-margin-5" name="smsmessage" id = "smsmessage" rows="2"  placeholder="Mesajınız.." style="resize:none;"></textarea>';
        $html .= '<select name="inputPhoneType" id="inputPhoneType" class="form-control bottom-margin-5"><option value="" selected>WHMCS</option><option value="' . $smsfieldname . '">' . $smsfieldname . '</option></select>';

        $html .= '<button type="button" onclick="sendSmssmsinteraktif()" id="sendsmsbutton" class="button btn btn-default">Gönder</button>';

        $html .= '</div>';
        $html .= '</div>';
//        $html .= '</div>';
//        $html .= '</div>';

        $script_1 = '<script>$(document).ready(function(){
            
            $(".client-summary-panels").children().last().append(\'' . $html . '\');
                        
        });</script>';

        return $script_1 . $script;

    });


} catch (Exception $e) {

}

function getHooks()
{
    $file = array();
    if ($handle = opendir(dirname(__FILE__) . '/hooks')) {
        while (false !== ($entry = readdir($handle))) {
            if (substr($entry, strlen($entry) - 4, strlen($entry)) == ".php") {
                array_push($file, include_once('hooks/' . $entry));
            }
        }
        closedir($handle);
    }
    return $file;
}

$service = null;