<?php
$hook = array(
    'hook' => 'AdminLogin',
    'function' => 'AdminLogin',
    'hook_tr' => 'Yönetici Girişi',
    'title' => '',
    'description' => array(
        'turkish' => 'Yönetici Girişi Yapıldığında Belirlenmiş Numaralara Mesaj Gönderir.',
        'english' => 'When an admin login it sends message.'
    ),
    'type' => 'admin',
    'extra' => '',
    'defaultmessage' => '{username}, Yonetici paneline giris yapti.',
    'variables' => '{username}'
);
if (!function_exists('AdminLogin')) {
    function AdminLogin($args)
    {
        $service = new SmsService();

        $template = $service->getTemplateDetails(__FUNCTION__);
        if ($template == false) {
            return null;
        }
        $templateRow = $template->fetch(PDO::FETCH_ASSOC);
        if ($templateRow['active'] == 0) {
            return null;
        }
        $message = $templateRow['template'];
        if (empty($templateRow['admingsm'])) {
            return null;
        }
        $phonenumber = explode(",", $templateRow['admingsm']);

        $settings = $service->getSettings();
        $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$settingsRow['usercode'] || !$settingsRow['password']) {
            return null;
        }
        if (strpos($message, "{username}") !== false) {
            $message = str_replace("{username}", $args['username'], $message);
        }
        $SMSArray = [];
        foreach ($phonenumber as $gsm) {
            if ($gsm{0} === "+") {
                $gsm = substr($gsm, 3);
                $gsm = str_replace(".", "0", $gsm);
                $gsm = str_replace(" ", "", $gsm);
            }
            if(strlen($gsm) == 12){
                $gsm = substr($gsm,1);
            }
            $gsm = str_replace(".","",$gsm);
            $gsm = str_replace(" ","",$gsm);

            if(ctype_digit($gsm)) {
                array_push($SMSArray, new SMS($message, trim($gsm)));
                $request = new Request($templateRow['title'], $SMSArray, $settingsRow['usercode'], $settingsRow['password']);
                $request->prepareXMLRequest();
                $request->XMLPOST();
            }
        }

    }
}

return $hook;
