<?php

$hook = array(
    'hook' => 'ClientAreaRegister',
    'function' => 'ClientAreaRegister',
    'hook_tr' => 'Yeni Müşteri - OTP',
    'title' => '',
    'description' => array(
        'turkish' => 'Müşteri kaydı tamamlandıktan sonra müşteriye telefon doğrulama mesajı gönderir ve kayıt işleminden sonra müşteri paneline telefon numarası doğrulama ekranı çıkartılır. Bu event sadece müşteri tarafında tetiklenebilir. Yönetici panelinden müşteri ekleme durumunda çalışmaz. OTP SMS gönderiminde mesajınız 1 boy olmalıdır. Türkçe karakter kullanımı önerilmez. Müşteri panel girişinde OTP sms ile doğrulama aktif edilmesi durumunda bu event çalışmaz.',
        'english' => 'After Client Registration it sends a message to the client. You can also send verification code with OTP SMS.'
    ),
    'type' => 'client',
    'extra' => '',
    'defaultmessage' => 'Sayin {firstname} {lastname}, Doğrulama Kodunuz: {code}',
    'variables' => '{firstname},{lastname},{code}'
);

if (!function_exists('ClientAreaRegister')) {
    function ClientAreaRegister($args)
    {
        $service = new SmsService();
        $userid = $args['userid'];

        $blocked = $service->isUserBlockedToSms($userid);
        if ($blocked == "1") {
            return null;
        }

        if (isset($_SESSION['is_interaktif_login_otp_sent']) and $_SESSION['is_interaktif_login_otp_sent'] == 1) {
            unset($_SESSION['is_interaktif_login_otp_sent']);
            return null;
        }

        $template = $service->getTemplateDetails(__FUNCTION__);
        if ($template == false) {
            return null;
        }
        $templateRow = $template->fetch(PDO::FETCH_ASSOC);
        if ($templateRow['active'] == 0) {
            return null;
        }
        $settings = $service->getSettings();
        $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$settingsRow['usercode'] || !$settingsRow['password']) {
            return null;
        }

        $stmt = $service->getClientDetailsBy($userid);
        $clientRow = $stmt->fetch(PDO::FETCH_ASSOC);

        $message = $templateRow['template'];
        $fields = $service->getFieldsWithName(__FUNCTION__);

        if (!empty($templateRow['smsfieldname'])) {

            $userSql = "SELECT c.*, v.value as `gsmnumber` FROM tblclients as c, tblcustomfieldsvalues as v
			WHERE c.id='" . $userid . "' AND c.id=v.relid AND v.fieldid=(SELECT id FROM tblcustomfields WHERE fieldname='" . $templateRow['smsfieldname'] . "' AND type='client' AND fieldtype='text' LIMIT 1) LIMIT 1;";

            $stmt = $service->getConnection()->runSelectQuery($userSql);
            if ($stmt == false) {
                return null;
            }
            $clientRow = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($clientRow !== null) {
                if (empty($clientRow['gsmnumber'])) {
                    return null;
                }
                $gsm = $clientRow['gsmnumber'];
            }

        } else {
            $gsm = $clientRow['phonenumber'];
            $gsmx = explode('.', $gsm);
            if (!empty($gsmx[1]))
                $gsm = $gsmx[1];
        }

        $code='';
        if (strpos($message, "{code}") !== false) {
            $code = rand(100000, 999999);
            $message = str_replace("{code}", $code, $message);
        }
        while ($field = $fields->fetch(PDO::FETCH_ASSOC)) {
            if (strpos($message, "{" . $field['field'] . "}") !== false) {
                $replaceto = $clientRow[$field['field']];
                $message = str_replace("{" . $field['field'] . "}", $replaceto, $message);
            }
        }

        $SMSArray = array();
        $gsm = str_replace(" ", "", $gsm);
        $gsm = str_replace("-", "", $gsm);

        if ($gsm{0} === "+") {
            $gsm = substr($gsm, 3);
        } else if ($gsm{0} === "9") {
            $gsm = substr($gsm, 2);
        }

        if (ctype_digit($gsm)){

            array_push($SMSArray, new SMS($message, $gsm));
            $request = new Request($templateRow['title'], $SMSArray, $settingsRow['usercode'], $settingsRow['password']);
            $reference_code = sha1($gsm . time() . $userid . $code);
            $sql = "INSERT INTO `interaktif_sms_otp`(`verification_code`, `reference_code`, `userid`, `phonenumber`,`start_otp_date`,`end_otp_date`,`islogin`) VALUES ('" . $code . "','" . $reference_code . "','" . $userid . "','" . $gsm . "',now(),date_add(now(),INTERVAL 5 MINUTE),0)";
            $service->getConnection()->runSelectQuery($sql);
            $request->XMLPOSTOTP();
            $_SESSION['is_interaktif_register_otp_sent'] = 1;
        }
    }
}

return $hook;