<?php

$hook = array(
    'hook' => 'ClientLogin',
    'function' => 'ClientLoginOtpAuth',
    'hook_tr' => 'Müşteri girişinde OTP ile doğrulama',
    'title' => '',
    'description' => array(
        'turkish' => 'Müşteri girişinde tek kullanımlık doğrulama kodu ile müşteri doğrulaması sağlanır. Bu şablonun (event) çalışması için Otomatik Giriş Anahtarını ayarlar sekmesinden belirtmiş olmalısınız.',
        'english' => 'When clients login send a otp message to the client phone number',
    ),
    'type' => 'client',
    'extra' => '',
    'defaultmessage' => 'Sayin {firstname} {lastname}, Dogrulama kodunuz : {code}.',
    'variables' => '{firstname}, {lastname}, {code}',
);

if (!function_exists('ClientLoginOtpAuth')) {
    function ClientLoginOtpAuth($args)
    {
        $userid = $args['userid'];

        $service = new SmsService();

        $blocked = $service->isUserBlockedToSms($userid);
        if ($blocked == "1") {
            return null;
        }

        $template = $service->getTemplateDetails(__FUNCTION__);
        if ($template == false) {
            return null;
        }
        $templateRow = $template->fetch(PDO::FETCH_ASSOC);
        if ($templateRow['active'] == 0) {
            return null;
        }


        if (isset($_SESSION['is_interaktif_register_otp_sent']) and $_SESSION['is_interaktif_register_otp_sent'] == 1) {
            unset($_SESSION['is_interaktif_register_otp_sent']);
            return null;
        }


        $sql = "SELECT `id`, `verification_code`, `reference_code`, `userid`, `phonenumber`, `start_otp_date`, `durum`,`islogin` FROM `interaktif_sms_otp` WHERE userid=" . $userid . " LIMIT 1";
        $login_stmt = $service->getConnection()->runSelectQuery($sql);

        $loginRow = $login_stmt->fetch();
        $islogin = $loginRow['islogin'];

        if (isset($islogin) and !empty($islogin) and trim($islogin) === "1") {
            unset($_SESSION['is_interaktif_login_otp_sent']);

            $sql = "update `interaktif_sms_otp` set islogin=0 where userid=".$userid." LIMIT 1";
            $service->getConnection()->runSelectQuery($sql);

        } else {


            $settings = $service->getSettings();
            $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
            if (!$settingsRow['usercode'] || !$settingsRow['password'] || !$settingsRow['autoauthkey']) {
                return null;
            }
            $message = $templateRow['template'];

            $stmt = $service->getClientDetailsBy($userid);
            $clientRow = $stmt->fetch(PDO::FETCH_ASSOC);

            $fields = $service->getFieldsWithName(__FUNCTION__);

            if (!empty($templateRow['smsfieldname'])) {
                $userSql = "SELECT c.*, v.value as `gsmnumber` FROM tblclients as c, tblcustomfieldsvalues as v
			WHERE c.id='" . $userid . "' AND c.id=v.relid AND v.fieldid=(SELECT id FROM tblcustomfields WHERE fieldname='" . $templateRow['smsfieldname'] . "' AND type='client' AND fieldtype='text' LIMIT 1) LIMIT 1;";

                $stmt = $service->getConnection()->runSelectQuery($userSql);

                if ($stmt == false) {
                    return null;
                }
                $clientRow = $stmt->fetch(PDO::FETCH_ASSOC);


                if ($clientRow !== null) {
                    if (empty($clientRow['gsmnumber'])) {
                        return null;
                    }
                    $gsm = $clientRow['gsmnumber'];
                }

            } else {
                $gsm = $clientRow['phonenumber'];
                if (strpos($gsm, '.') !== false) {
                    $gsm = explode('.', $gsm);
                    $gsm = $gsm[1];
                }
            }
            $code = '';
            if (strpos($message, "{code}") !== false) {
                $code = rand(100000, 999999);
                $message = str_replace("{code}", $code, $message);
            }
            while ($field = $fields->fetch(PDO::FETCH_ASSOC)) {
                if (strpos($message, "{" . $field['field'] . "}") !== false) {
                    $replaceto = $clientRow[$field['field']];
                    $message = str_replace("{" . $field['field'] . "}", $replaceto, $message);
                }
            }

            $message = str_replace("{", "", $message);
            $message = str_replace("}", "", $message);

            $SMSArray = array();
            $gsm = str_replace(" ", "", $gsm);
            $gsm = str_replace("-", "", $gsm);

            if ($gsm{0} === "+") {
                $gsm = substr($gsm, 3);
            } else if ($gsm{0} === "9") {
                $gsm = substr($gsm, 2);
            }

            if (ctype_digit($gsm)) {

                array_push($SMSArray, new SMS($message, $gsm));
                $reference_code = sha1($gsm . time() . $userid . $code);

                $sql = "SELECT `id`, `verification_code`, `reference_code`, `userid`, `phonenumber`, `start_otp_date`, `durum` 
                    FROM `interaktif_sms_otp`
                    WHERE phonenumber=:gsm and userid=:usr LIMIT 1";
                $stmt = $service->getConnection()->runSelectQuery($sql, array(':gsm' => $gsm, ':usr' => $userid));
                $otp_row = $stmt->fetch();

                if ($otp_row) {

                    $current_reference = $otp_row['reference_code'];
                    $otp_id = $otp_row['id'];

                    $sql = "update `interaktif_sms_otp` set durum=0,islogin=0,start_otp_date=now(),end_otp_date=(select date_add(now(),INTERVAL 5 MINUTE)), reference_code=:new_reference,verification_code=:code where id=:otp_id and reference_code=:reference and userid=:usr";
                    $array_execute = array(':otp_id' => $otp_id, ':new_reference' => $reference_code, ':code' => $code, ':reference' => $current_reference, ':usr' => $userid);
                    $stmt = $service->getConnection()->runSelectQuery($sql, $array_execute);

                } else {
                    $sql = "INSERT INTO `interaktif_sms_otp`(`verification_code`, `reference_code`, `userid`, `phonenumber`,`start_otp_date`,`end_otp_date`,`islogin`) VALUES ('" . $code . "','" . $reference_code . "','" . $userid . "','" . $gsm . "',now(),date_add(now(),INTERVAL 5 MINUTE),0)";
                    $service->getConnection()->runSelectQuery($sql);
                }


                $request = new Request($templateRow['title'], $SMSArray, $settingsRow['usercode'], $settingsRow['password']);
                $request->XMLPOSTOTP();
                $_SESSION['is_interaktif_login_otp_sent'] = 1;


                $session_temp = $_SESSION;
                session_unset();
                $_SESSION['interaktif_session_temp'] = $session_temp;

                header("Location: index.php?m=interaktif&action=loginWithOtp&reference_code=" . $reference_code);
                exit;
            }

        }

    }

}


return $hook;
