<?php
$hook = array(
    'hook' => 'ClientLogin',
    'function' => 'ClientLogin_admin',
    'hook_tr' => 'Müşteri Girişi',
    'title' => '',
    'description' => array(
        'turkish' => 'Müşteri Sisteme Giriş Yaptıktan Sonra Yöneticiye Mesaj Gönderir',
        'english' => 'When client login it sends a message to the admin.'
    ),
    'type' => 'admin',
    'extra' => '',
    'defaultmessage' => '({firstname} {lastname}), Siteye giris yapti',
    'variables' => '{firstname},{lastname}'
);

if (!function_exists('ClientLogin_admin')) {
    function ClientLogin_admin($args)
    {
        $service = new SmsService();

        $template = $service->getTemplateDetails(__FUNCTION__);
        if ($template == false) {
            return null;
        }
        $templateRow = $template->fetch(PDO::FETCH_ASSOC);
        if ($templateRow['active'] == 0) {
            return null;
        }
        $message = $templateRow['template'];
        if (empty($templateRow['admingsm'])) {
            return null;
        }
        $phonenumber = explode(",", $templateRow['admingsm']);

        $settings = $service->getSettings();
        $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$settingsRow['usercode'] || !$settingsRow['password']) {
            return null;
        }

        $stmt = $service->getClientDetailsBy($args['userid']);
        if ($stmt == false) {
            return null;
        }
        $clientRow = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($clientRow !== null) {

            $fields = $service->getFieldsWithName(__FUNCTION__);

            while ($field = $fields->fetch(PDO::FETCH_ASSOC)) {

                if (strpos($message, "{" . $field['field'] . "}") !== false) {
                    $replaceto = $clientRow[$field['field']];
                    $message = str_replace("{" . $field['field'] . "}", $replaceto, $message);
                }
            }

            $SMSArray = [];
            foreach ($phonenumber as $gsm) {

                if(strlen($gsm) == 12){
                    $gsm = substr($gsm,1);
                }
                $gsm = str_replace(".","",$gsm);
                $gsm = str_replace(" ","",$gsm);

                if(ctype_digit($gsm)) {
                    array_push($SMSArray, new SMS($message, trim($gsm)));
                    $request = new Request($templateRow['title'], $SMSArray, $settingsRow['usercode'], $settingsRow['password']);
                    $request->prepareXMLRequest();
                    $request->XMLPOST();
                }
            }
        }
    }
}

return $hook;
