<?php
$hook = array(
    'hook' => 'AfterRegistrarRegistration',
    'function' => 'AfterRegistrarRegistration_admin',
    'hook_tr' => 'Alan Adı Kayıt',
    'title' => '',
    'description' => array(
        'turkish' => 'Bir domain kayıt edildikten sonra yöneticiye mesaj gönderir.',
        'english' => 'After domain registration it sends a message to the admin'
    ),
    'type' => 'admin',
    'extra' => '',
    'defaultmessage' => 'Yeni domain kayit edildi. ({domain})',
    'variables' => '{domain}'
);
if (!function_exists('AfterRegistrarRegistration_admin')) {
    function AfterRegistrarRegistration_admin($args)
    {
        $service = new SmsService();

        $template = $service->getTemplateDetails(__FUNCTION__);
        if ($template == false) {
            return null;
        }
        $templateRow = $template->fetch(PDO::FETCH_ASSOC);
        if ($templateRow['active'] == 0) {
            return null;
        }
        $message = $templateRow['template'];
        if (empty($templateRow['admingsm'])) {
            return null;
        }
        $phonenumber = explode(",", $templateRow['admingsm']);

        $settings = $service->getSettings();
        $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$settingsRow['usercode'] || !$settingsRow['password']) {
            return null;
        }
        if (strpos($message, "{domain}") !== false) {
            $message = str_replace("{domain}", $args['params']['sld'].".".$args['params']['tld'], $message);
        }

        $SMSArray = [];
        foreach ($phonenumber as $gsm) {
            if(strlen($gsm) == 12){
                $gsm = substr($gsm,1);
            }
            $gsm = str_replace(".","",$gsm);
            $gsm = str_replace(" ","",$gsm);

            if(ctype_digit($gsm)) {
                array_push($SMSArray, new SMS($message, trim($gsm)));
                $request = new Request($templateRow['title'], $SMSArray, $settingsRow['usercode'], $settingsRow['password']);
                $request->prepareXMLRequest();
                $request->XMLPOST();
            }
        }

    }
}

return $hook;