<?php
$hook = array(
    'hook' => 'ClientAdd',
    'function' => 'ClientAdd_admin',
    'hook_tr' => 'Yeni Müşteri',
    'title' => '',
    'description' => array(
        'turkish' => 'Müşteri kaydı tamamlandıktan sonra yöneticiye mesaj gönderir.',
        'english' => 'After Client Registration it sends a message to the admin.'
    ),
    'type' => 'admin',
    'extra' => '',
    'defaultmessage' => 'Yeni bir müşteri www.interaktif.com.tr adresine kayıt oldu.',
    'variables' => ''
);
if (!function_exists('ClientAdd_admin')) {
    function ClientAdd_admin($args)
    {
        $service = new SmsService();

        $template = $service->getTemplateDetails(__FUNCTION__);
        if ($template == false) {
            return null;
        }

        $templateRow = $template->fetch(PDO::FETCH_ASSOC);

        if ($templateRow['active'] == 0) {

            return null;
        }
        if (empty($templateRow['admingsm'])) {

            return null;
        }
        $settings = $service->getSettings();
        $settingsRow = $settings->fetch(PDO::FETCH_ASSOC);
        if (!$settingsRow['usercode'] || !$settingsRow['password']) {
            return null;
        }

        $message = $templateRow['template'];
        $phonenumber = explode(",", $templateRow['admingsm']);

        $fields = $service->getFieldsWithName(__FUNCTION__);

        while ($field = $fields->fetch(PDO::FETCH_ASSOC)) {

            if (strpos($message, "{" . $field['field'] . "}") !== false) {
                $replaceto = $args[$field['field']];
                $message = str_replace("{" . $field['field'] . "}", $replaceto, $message);
            }
        }

        $SMSArray = [];
        foreach ($phonenumber as $gsm) {

            if(strlen($gsm) == 12){
                $gsm = substr($gsm,1);
            }
            $gsm = str_replace(".","",$gsm);
            $gsm = str_replace(" ","",$gsm);

            if(ctype_digit($gsm)) {
                array_push($SMSArray, new SMS($message, trim($gsm)));
                $request = new Request($templateRow['title'], $SMSArray, $settingsRow['usercode'], $settingsRow['password']);
                $request->prepareXMLRequest();
                $request->XMLPOST();
            }
        }

    }
}
return $hook;