<?php

namespace WHMCS\Module\Addon\Lib\Smsinteraktif\Client;

use WHMCS\Module\Addon\Smsinteraktif\sender;

/**
 * Sample Client Area Controller
 */
class Controller
{

    /**
     * Index action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return array
     */

    public function index($vars)
    {
        return array(
            'pagetitle' => 'loginWithOtp',
            'breadcrumb' => array(
                'index.php?m=smsinteraktif&action=loginWithOtp' => 'Kullanıcı Doğrulama',
            ),
            'templatefile' => 'secretpage',
            'requirelogin' => false,
            'forcessl' => false,
        );

    }

    public function loginWithOtp($vars)
    {
        $code = 0;
        $parameters = array();
        $parameters['timezero'] = '0';

        try {
            $service = new \SmsService();
            $sql = "select nso.id, nso.verification_code, nso.reference_code, nso.userid, nso.phonenumber, nso.start_otp_date,nso.end_otp_date, nso.durum,c.email
                    ,(case when now()<nso.end_otp_date then '0'
                    else '1' end) as timesup
                    from smsinteraktif_sms_otp as nso
                    inner join tblclients as c on c.id=nso.userid
                    where nso.reference_code=:reference and nso.durum = 0 LIMIT 1";

            $array_execute = array(':reference' => $_REQUEST['reference_code']);
            $stmt = $service->getConnection()->runSelectQuery($sql, $array_execute);
            $row = $stmt->fetch();
            $userid = $row['userid'];
            $email = $row['email'];
            $code = trim($row['verification_code']);
            $timesup = $row['timesup'];

            $parameters['start_otp_date'] = $row['start_otp_date'] ? $row['start_otp_date'] : "0";
            $parameters['phonenumber'] = $row['phonenumber'] ? $row['phonenumber'] : "";
            $parameters['timesup'] = $timesup;

            $sql_time = "select TIMESTAMPDIFF(SECOND,now(),'" . $row['end_otp_date'] . "') as remaining_time";
            $stmt_time = $service->getConnection()->runSelectQuery($sql_time);
            $row = $stmt_time->fetch();
            $parameters['remaining_time'] = $row['remaining_time'] ? $row['remaining_time'] : "0";

            if ($timesup === "1") {
                $parameters['message'] = 'Doğrulama kodunun geçerlilik süresi dolmuş.';
            }

            if ($row == false || $parameters['phonenumber'] == '') {
                $parameters['timesup'] = "1";
                $parameters['message'] = 'Doğrulanacak telefon numarası bulunamadı.';
            }

        } catch (Exception $e) {
            $parameters['message'] = 'Doğrulanacak telefon numarası bulunamadı.';
        }

        $parameters['reference_code'] = $_REQUEST['reference_code'];
        $reference_code = $_REQUEST['reference_code'];

        if ($timesup === "0" and isset($_REQUEST['otp_code']) and $code === trim($_REQUEST['otp_code'])) {

            $whmcsurl = "dologin.php";
            $goto = 'clientarea.php';
            $settings = $service->getSettings();
            $settingsRow = $settings->fetch();
            if (!$settingsRow['usercode'] || !$settingsRow['password']) {
                return null;
            }

            $autoauthkey = trim($settingsRow['autoauthkey']);

            if (!empty($settingsRow['loginredirectpage']) and $settingsRow['loginredirectpage'] != '') {
                $goto = trim($settingsRow['loginredirectpage']);
            }
            if (!empty($settingsRow['loginpage']) and $settingsRow['loginpage'] != '') {
                $whmcsurl = trim($settingsRow['loginpage']);
            }

            if ($autoauthkey == '' and $whmcsurl == '') {
                header("Location: index.php");
                exit;
            }

            $timestamp = time();



            $hash = sha1($email . $timestamp . $autoauthkey);
            $url = $whmcsurl . "?email=" . $email . "&timestamp=" . $timestamp . "&hash=" . $hash . "&goto=" . urlencode($goto);

            unset($_SESSION['is_smsinteraktif_login_otp_sent']);

            if (isset($_SESSION['smsinteraktif_session_temp'])) {
                $_SESSION = $_SESSION['smsinteraktif_session_temp'];
            }

            $sql = "update `smsinteraktif_sms_otp` set durum = 1,islogin = 1 where reference_code=:reference and verification_code=:code";
            $service->getConnection()->runSelectQuery($sql, array(':reference' => $reference_code, ':code' => $code));
            header("Location: $url");
            exit;

        } elseif ($timesup === "0" and isset($_REQUEST['otp_code']) and $code !== $_REQUEST['otp_code']) {
            $parameters['message'] = 'Doğrulama kodunuz yanlış. Lütfen kontrol ediniz.';

        }

//        print_r($parameters);
//        exit;

        return array(
            'pagetitle' => 'Telefon Doğrulama',
            'breadcrumb' => array(
                'index.php?m=smsinteraktif&action=loginWithOtp' => 'Kullanıcı Doğrulama',
            ),
            'templatefile' => 'publicpage',
            'requirelogin' => false,
            'forcessl' => false,
            'vars' => $parameters,
        );

    }

}
