<?php

include_once('../SmsService.php');

class Request
{
    private $xmlRequest;
    private $SMS = [];           //// SMS class object array to hold each sms infos
    private $usercode;
    private $password;
    private $title;
    private $url;
    private $language;

    function __construct($title, $SMS, $usercode, $password)
    {
        $this->title = $title;
        $this->SMS = $SMS;
        $this->usercode = $usercode;
        $this->password = $password;
        $this->setLanguage();
    }


    function XMLPOST()
    {
        $mmm = $this->xmlRequest;
        $sss = json_decode($mmm, true);
        $user = $sss['username'];
        $title = $sss['source_addr'];
        $password = $sss['password'];
        //print_r($mmm);
        foreach($sss['messages'] as $item)
        {
            $mesaj = $item['msg'];
            $no = $item['dest'];
          
            if(substr($no, 0,1) == 0)
            {
               
            }
            else
            {
                $no = "0".$no;
            }
            $curl = curl_init();
                curl_setopt_array($curl, array(
                  CURLOPT_URL => 'http://panel.1sms.com.tr:8080/api/smspost/v1%20',
                  CURLOPT_RETURNTRANSFER => true,
                  
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'POST',
                  CURLOPT_POSTFIELDS =>'<sms>
                    <username>'.$user.'</username>
                    <password>'.$password.'</password>
                    <header>'.$title.'</header>
                    <validity>2880</validity>
                   
                    <message>
                        <gsm>
                            <no>+9'.$no.'</no>
                           
                        </gsm>
                        <msg><![CDATA['.$mesaj.']]></msg>
                    </message>
                </sms>
                ',
                 CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded; charset=utf-8'
  ),
                ));
                
                
             $response = curl_exec($curl);

        }
   
      return "00 00";
    }

    function XMLPOSTOTP()
    {
        
        $url = "http://sms.smsinteraktif.com.tr/v2/send.json";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, Array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $this->getXmlOtpRequest());
        $result = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
        }
        curl_close($ch);

        if (isset($error_msg)) {
            return $error_msg;
        }

        if ($http_code == 200)
            return "00 Basarili";
        else
            return $result;
    }

    public static function HTTPGET($u, $p)
    {
        $vowels = array(" ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", '"');

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'http://panel.1sms.com.tr:8080/api/originator/v1?username='.$u.'&password='.$p);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $res = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
       
      return str_replace($vowels, "",$res);
      
     
    }

    public function setLanguage()
    {
        $service = new SmsService();
        $settings = $service->getSettings();
        $settingsRow = $settings->fetch();

        $this->language = trim($settingsRow['smslanguage']);
    }


    /**
     * Prepare Xml Request
     */
   public function prepareXMLRequest()
    {
        try {
            $sms_pkg = array(
                "username" => $this->usercode,
                "password" => $this->password,
                "source_addr" => $this->title,
                "messages" => array()
            );

            foreach ($this->SMS as $SM) {
                if ($this->language == "tr") {
                    $message = $SM->getMessage();
                } else {
                    $message = $this->replace_tr($SM->getMessage());
                }
                array_push($sms_pkg["messages"], array("msg" => $message, "dest" => $SM->getDestination()));
            }

            $this->xmlRequest = json_encode($sms_pkg);
            
        } catch (Exception $e) {
            return 'XML HEADER ERROR';
        }
    }

    function getXmlOtpRequest()
    {
        $sms_pkg = array(
            "username" => $this->usercode,
            "password" => $this->password,
            "sourceheader_addr" => $this->title,
            "valid_for" => "00:03",
            "messages" => array()
        );
        
        foreach ($this->SMS as $SM) {
            array_push($sms_pkg["messages"], array("msg" => $SM->getMessage(), "dest" => $SM->getDestination()));
        }
die(var_dump($sms_pkg));
        return json_encode($sms_pkg);
    }

    function replace_tr($text)
    {
        $text = trim($text);
        $search = array('Ç', 'ç', 'Ğ', 'ğ', 'ı', 'İ', 'Ö', 'ö', 'Ş', 'ş', 'Ü', 'ü');
        $replace = array('C', 'c', 'G', 'g', 'i', 'I', 'O', 'o', 'S', 's', 'U', 'u');
        $new_text = str_replace($search, $replace, $text);
//        $new_text = preg_replace("/[^a-zA-Z0-9.]+/", "", $new_text);

        return $new_text;
    }
}

?>
